/**
 * Created by lei.wang_1 on 2016/8/22.
 */
appModule.directive("map",[function(){
    return {
        template: '<div id="bdMap"></div>',
        restrict: "AE",
        replace:true,
        scope: {
            disableDrag: "=",
            defaultCursor:"@",
            onGetCoordinate:"&",
            location:"="
        },
        link: function ($scope,element) {
            var map = new BMap.Map(element[0]);
            var myCity = new BMap.LocalCity();

            if($scope.disableDrag){
                map.disableDragging();
                map.disableDoubleClickZoom();
            }else{
                map.addControl(new BMap.NavigationControl());
                map.enableScrollWheelZoom();
            }

            map.setDefaultCursor($scope.defaultCursor); 
            
            function myFun(result){
                var cityName = result.name;
                map.setCenter(cityName);
                var point = new BMap.Point(result.center.lng,result.center.lat);
                map.centerAndZoom(point,12);
            }
            myCity.get(myFun);

            map.addEventListener("click",function(e){
                $scope.onGetCoordinate({latitude:e.point.lat,longitude:e.point.lng});
            });
            
            $scope.$watch('location',function(newV,oldV){
                if(newV){
                    if(newV.latitude && newV.langitude){
                        var point = new BMap.Point(newV.langitude, newV.latitude);
                        var marker = new BMap.Marker(point);
                        map.addOverlay(marker);
                        map.centerAndZoom(point,16);
                    }   
                }                
            });
        }
    }
}]);